/****** Object:  StoredProcedure [dbo].[P_EST_PROD_BALAN_REPROCESSAMENTO]    Script Date: 04/30/2013 17:54:03 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_BALAN_REPROCESSAMENTO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_BALAN_REPROCESSAMENTO]
GO
GO
--EXEC P_EST_PROD_BALAN_REPROCESSAMENTO 1,4,1,1
CREATE PROCEDURE P_EST_PROD_BALAN_REPROCESSAMENTO (@CD_EMP INT,
												  @CD_FILIAL INT,
												  @CD_BALAN INT,
												  @CD_USU INT)
AS
SET NOCOUNT ON;
DECLARE @TIPO_ESTQ INT
DECLARE @CD_IMP INT
DECLARE @DT_BALAN DATETIME
DECLARE @DT_MES_FECHA DATETIME
DECLARE @ANO INT
DECLARE @MES INT
DECLARE @DT_ATUAL DATETIME
DECLARE @ANOATUAL INT
DECLARE @MESATUAL INT
DECLARE @MESDIFFECHA INT
DECLARE @MESPROC INT
DECLARE @DT_FECHAMENTO DATETIME

SET @CD_IMP=ISNULL((SELECT
	TOP 1 CD_IMP
FROM
	EST_PROD_IMP_EST_PROD_BALAN_IT
WHERE
	CD_EMP=@CD_EMP
	AND CD_FILIAL=@CD_FILIAL
	AND CD_BALAN=@CD_BALAN),0)

IF @CD_IMP > 0
BEGIN
	PRINT 'Buscando dados do balanco ' + CONVERT(VARCHAR, GETDATE (),108)
	--Buscando data do balanco cadastro
	SELECT
		@DT_BALAN=DT_CAD,
		@TIPO_ESTQ=TP_EST
	FROM
		EST_PROD_BALAN
	WHERE
		CD_EMP=@CD_EMP
		AND CD_FILIAL=@CD_FILIAL
		AND CD_BALAN=@CD_BALAN	

	SET @DT_MES_FECHA=DBO.F_INICIO_MES(@DT_BALAN) 
	SET @DT_MES_FECHA=@DT_MES_FECHA-1
	SET @ANO=YEAR(dbo.F_FINAL_MES(@DT_MES_FECHA));
	SET @MES=MONTH(dbo.F_FINAL_MES(@DT_MES_FECHA));

	PRINT 'deletando alteracao balanco ' + CONVERT(VARCHAR, GETDATE (),108)
	--Deletando alteracoes do balanco
	DELETE
	FROM
		EST_PROD_BALAN_IT_ALT
	WHERE
		CD_EMP=@CD_EMP
		AND CD_FILIAL=@CD_FILIAL
		AND CD_BALAN=@CD_BALAN

	PRINT 'delete eventos do balanco ' + CONVERT(VARCHAR, GETDATE (),108)
	--Deletando data eventos
	DELETE
	FROM
		EST_PROD_BALAN_EVENTOS
	WHERE
		CD_EMP =@CD_EMP
		AND CD_FILIAL=@CD_FILIAL
		AND DT_CAD=@DT_BALAN

	PRINT 'Alterando status do balanco ' + CONVERT(VARCHAR, GETDATE (),108)
	--Alterando status do balanco
	UPDATE
		EST_PROD_BALAN
	SET
		STS_BALAN=1,
		CD_USU=@CD_USU		
	WHERE
		CD_EMP=@CD_EMP
		AND CD_FILIAL=@CD_FILIAL
		AND CD_BALAN=@CD_BALAN

	PRINT 'deletando vinculo do ajuste do balanco ' + CONVERT(VARCHAR, GETDATE (),108)
	--Deletando vinculo do balanco com o ajuste de estoque			
	DELETE
	FROM
		EST_PROD_IMP_EST_PROD_BALAN_IT
	WHERE
		CD_EMP=@CD_EMP
		AND CD_FILIAL=@CD_FILIAL
		AND CD_BALAN=@CD_BALAN

	PRINT 'deletando ajuste de balanco ' + CONVERT(VARCHAR, GETDATE (),108)
	--Deletando ajuste de estoque
	DELETE
	FROM
		EST_PROD_IMP
	WHERE
		CD_EMP =@CD_EMP
		AND CD_FILIAL=@CD_FILIAL 
		AND CD_IMP=@CD_IMP

	PRINT 'Refazendo o fechamento de estoque anoMes ' + CONVERT(VARCHAR, @ANO*100+@MES)  + ' ' + CONVERT(VARCHAR, GETDATE (),108)
    EXECUTE P_EST_FECHA_FILIAL_MES @CD_EMP,@CD_FILIAL,@ANO,@MES

	PRINT 'Realizando acerto de estoque por movimentacao ' + CONVERT(VARCHAR, GETDATE (),108)
	EXECUTE P_EST_PROD_EXTRATO_CALC @CD_EMP,@CD_FILIAL,@TIPO_ESTQ

	--Iniciando fechamento do balanco
	DECLARE @CD_IMP_NOVO INT
	SET @CD_IMP_NOVO= ISNULL((SELECT
							MAX(CD_IMP)
						 FROM
							EST_PROD_IMP
						WHERE
							CD_EMP =@CD_EMP
							AND CD_FILIAL =@CD_FILIAL),0)+1

	PRINT 'Realizando o ajuste de estoque do balanco ' + CONVERT(VARCHAR, GETDATE (),108)
	INSERT INTO 
		EST_PROD_IMP (CD_EMP,CD_FILIAL,CD_IMP,CD_PROD,QT_ANT,QT_IMP,CD_USU,DT_CAD,HIST,TP_IMP,TP_EST,VLR_CUSTO_MD,DT_CAD_INFO,HR_CAD)
	SELECT
		CD_EMP,
		CD_FILIAL,
		@CD_IMP_NOVO AS CD_IMP,
		CD_PROD,
		QT_IT,
		(QT_IT- QT_IT_BALAN) *-1 AS QT_IMP,
		@CD_USU AS CD_USU,
		@DT_BALAN+1 AS DT_CAD,
		'Ajuste de estoque referente balanco ' + CONVERT(VARCHAR(10),@CD_BALAN) AS HIST,
		0 AS TP_IMP,
		@TIPO_ESTQ AS TP_EST,
		VLR_CP AS VLR_CUSTO_MD,
		GETDATE() AS DT_CAD_INFO,
		GETDATE() AS HR_CAD
	FROM
		EST_PROD_BALAN_IT
	WHERE
	CD_EMP=@CD_EMP
	AND CD_FILIAL =@CD_FILIAL
	AND CD_BALAN=@CD_BALAN
	AND QT_IT_BALAN <> QT_IT

	PRINT 'Vinculando o ajuste de estoque com o balanco ' + CONVERT(VARCHAR, GETDATE (),108)
	INSERT INTO EST_PROD_IMP_EST_PROD_BALAN_IT
	SELECT
		CD_EMP,
		CD_FILIAL,
		@CD_IMP_NOVO AS CD_IMP,
		@CD_BALAN AS CD_BALAN,
		CD_PROD 
	FROM 
		EST_PROD_BALAN_IT
	WHERE
	CD_EMP=@CD_EMP
	AND CD_FILIAL =@CD_FILIAL
	AND CD_BALAN=@CD_BALAN
	AND QT_IT_BALAN <> QT_IT

	--Fechando balanco
	UPDATE
		EST_PROD_BALAN
	SET
		STS_BALAN=2
	WHERE
		CD_EMP=@CD_EMP
		AND CD_FILIAL=@CD_FILIAL
		AND CD_BALAN=@CD_BALAN

	--Buscando data atual
	SET @DT_ATUAL=GETDATE()
	SET @ANOATUAL=YEAR(@DT_ATUAL)
	SET @MESATUAL=MONTH(@DT_ATUAL)
	SET @MESDIFFECHA = DATEDIFF(MONTH,@DT_BALAN,@DT_ATUAL)
	SET @MESPROC =0
	IF @MESDIFFECHA > 0
	BEGIN
		WHILE   @MESPROC < @MESDIFFECHA
		BEGIN  
			SET @DT_FECHAMENTO= DATEADD(MONTH,@MESPROC,@DT_BALAN)

			--Anoe e mes do fechamento
			SET @ANO=YEAR(dbo.F_FINAL_MES(@DT_FECHAMENTO));
			SET @MES=MONTH(dbo.F_FINAL_MES(@DT_FECHAMENTO));
			--se o mes de reprocessamento for anterior ao inicio do sistema aborta o fechamento
			if (@ANO*100+@MES) < (@ANOATUAL*100+@MESATUAL)
			BEGIN
				PRINT 'Refazendo o fechamento de estoque anoMes ' + ' mes ' + CONVERT(VARCHAR, @ANO*100+@MES)  + ' ' + CONVERT(VARCHAR, GETDATE (),108)
				EXECUTE P_EST_FECHA_FILIAL_MES @CD_EMP,@CD_FILIAL,@ANO,@MES
			END 
		   SET @MESPROC=@MESPROC+1
		END  
	END

	PRINT 'Realizando acerto de estoque por movimentacao ' + CONVERT(VARCHAR, GETDATE (),108)
	EXECUTE P_EST_PROD_EXTRATO_CALC @CD_EMP,@CD_FILIAL,@TIPO_ESTQ
END
